// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanAntitrackingMetrics_h
#define mozilla_GleanAntitrackingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace contentblocking {
  /**
   * generated from contentblocking.canvas_fingerprinting_per_tab
   */
  enum class CanvasFingerprintingPerTabLabel: uint16_t {
    eKnownText = 0,
    eUnknown = 1,
    eUnknownMatched = 2,
    eKnownTextMatched = 3,
    e__Other__,
  };
  /**
   * Type of canvas fingerprinter detected (keyed by known_fingerprinting_text or unknown), 0 = none
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CANVAS_FINGERPRINTING_PER_TAB.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, CanvasFingerprintingPerTabLabel> canvas_fingerprinting_per_tab(4556);

  /**
   * generated from contentblocking.canvas_fingerprinting_per_tab2
   */
  enum class CanvasFingerprintingPerTab2Label: uint16_t {
    eNotFound = 0,
    eFound = 1,
    e__Other__,
  };
  /**
   * Whether any canvas fingerprinting attempt was detected, as identified by either a known fingerprinting text or a known behavior (alias)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CanvasFingerprintingPerTab2Label> canvas_fingerprinting_per_tab2(4557);

  /**
   * generated from contentblocking.canvas_fingerprinting_type_alias_by_source_per_tab2
   * Fingerprinting detection hits by fingerprinter alias (key) and the source(s) used (category). An alias using multiple sources will increment each source individually once, and increment the combination once as well.
   */
  constexpr impl::DualLabeledCounterMetric canvas_fingerprinting_type_alias_by_source_per_tab2(4558);

  /**
   * generated from contentblocking.canvas_fingerprinting_type_text_by_source_per_tab2
   * Fingerprinting detection hits by known fingerprinting string (key) and source (category).
   */
  constexpr impl::DualLabeledCounterMetric canvas_fingerprinting_type_text_by_source_per_tab2(4559);

  /**
   * generated from contentblocking.category
   * This scalar reports the value of the content blocking category pref (0 = "standard", 1 = "strict", 2 = "custom", 3 = some other value, this is not supported). This metric was generated to correspond to the Legacy Telemetry scalar contentblocking.category.
   */
  constexpr impl::QuantityMetric category(4560);

  /**
   * generated from contentblocking.cookie_behavior
   * Records the cookie behavior pref at startup.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram COOKIE_BEHAVIOR.
   */
  constexpr impl::CustomDistributionMetric cookie_behavior(4561);

  /**
   * generated from contentblocking.cryptominers_blocked_count
   */
  enum class CryptominersBlockedCountLabel: uint16_t {
    ePageload = 0,
    eBlocked = 1,
    eAllowed = 2,
    e__Other__,
  };
  /**
   * A count of the status of cryptominer blocking per top level page load. ('pageLoad' = There was a page load, 'blocked' = at least one cryptominer was blocked, 'allowed' = at least one cryptominer was detected and allowed.) Note, pageLoad is used as a baseline measurement.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram CRYPTOMINERS_BLOCKED_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CryptominersBlockedCountLabel> cryptominers_blocked_count(4562);

  /**
   * generated from contentblocking.cryptomining_blocking_enabled
   * True if cryptominer blocking is enabled globally at startup. This metric was generated to correspond to the Legacy Telemetry scalar contentblocking.cryptomining_blocking_enabled.
   */
  constexpr impl::BooleanMetric cryptomining_blocking_enabled(4563);

  /**
   * generated from contentblocking.email_tracker_count
   */
  enum class EmailTrackerCountLabel: uint16_t {
    eBaseNormal = 0,
    eContentNormal = 1,
    eBaseEmailWebapp = 2,
    eContentEmailWebapp = 3,
    e__Other__,
  };
  /**
   * A count of the classified email trackers. ('base_normal' = The classified email tracker is in base category and loaded under a normal site, 'content_normal' = The classified email tracker is in content category and loaded under a normal site, 'base_email_webapp' = The classified email tracker is in base category and loaded under a known email webapp, 'content_email_webapp' = The classified email tracker is in content category and loaded under a known email webapp.)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram EMAIL_TRACKER_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EmailTrackerCountLabel> email_tracker_count(4564);

  /**
   * generated from contentblocking.email_tracker_embedded_per_tab
   */
  enum class EmailTrackerEmbeddedPerTabLabel: uint16_t {
    eBaseNormal = 0,
    eContentNormal = 1,
    eAllNormal = 2,
    eBaseEmailapp = 3,
    eContentEmailapp = 4,
    eAllEmailapp = 5,
    e__Other__,
  };
  /**
   * A count of the embedded third-party email trackers for known email web apps. ('base_normal' = The count of loaded base email trackers under normal sites, 'content_normal' = The count of loaded content email trackers under normal sites, 'all_normal' = The count of all loaded email trackers under normal sites, 'base_emailapp' = The count of loaded base email trackers under email webapps, 'content_emailapp' = The count of loaded content email trackers under email webapps, 'all_emailapp' = The count of all loaded email trackers under email webapps.)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram EMAIL_TRACKER_EMBEDDED_PER_TAB.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, EmailTrackerEmbeddedPerTabLabel> email_tracker_embedded_per_tab(4565);

  /**
   * generated from contentblocking.fingerprinters_blocked_count
   */
  enum class FingerprintersBlockedCountLabel: uint16_t {
    ePageload = 0,
    eBlocked = 1,
    eAllowed = 2,
    e__Other__,
  };
  /**
   * A count of the status of fingerprinter blocking per top level page load. ('pageLoad' = There was a page load, 'blocked' = at least one fingerprinter was blocked, 'allowed' = at least one fingerprinter was detected and allowed.) Note, pageLoad is used as a baseline measurement.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram FINGERPRINTERS_BLOCKED_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FingerprintersBlockedCountLabel> fingerprinters_blocked_count(4566);

  /**
   * generated from contentblocking.fingerprinting_blocking_enabled
   * True if fingerprinter blocking is enabled globally at startup. This metric was generated to correspond to the Legacy Telemetry scalar contentblocking.fingerprinting_blocking_enabled.
   */
  constexpr impl::BooleanMetric fingerprinting_blocking_enabled(4567);

  /**
   * generated from contentblocking.font_fingerprinting_per_tab
   */
  enum class FontFingerprintingPerTabLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a probable font fingerprinting attempt was detected
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram FONT_FINGERPRINTING_PER_TAB.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FontFingerprintingPerTabLabel> font_fingerprinting_per_tab(4568);

  /**
   * generated from contentblocking.query_stripping_count
   */
  enum class QueryStrippingCountLabel: uint16_t {
    eNavigation = 0,
    eRedirect = 1,
    eStripfornavigation = 2,
    eStripforredirect = 3,
    e__Other__,
  };
  /**
   * A count of the query stripping. ('Navigation' = There was a top-level loading via navigation, 'Redirect' = There was a top-level loading via redirect, 'StripForNavigation' = There was a stripping happened for a top-level navigation, 'StripForRedirect' = There was a stripping happened for a top-level redirect.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram QUERY_STRIPPING_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, QueryStrippingCountLabel> query_stripping_count(4569);

  /**
   * generated from contentblocking.query_stripping_count_by_param
   */
  enum class QueryStrippingCountByParamLabel: uint16_t {
    eParamMcEid = 0,
    eParamOlyAnonId = 1,
    eParamOlyEncId = 2,
    eParamS = 3,
    eParamVeroId = 4,
    eParamHsenc = 5,
    eParamMktTok = 6,
    eParamFbclid = 7,
    eParamGclid = 8,
    eParamDclid = 9,
    eParamMsclkid = 10,
    eParamOpenstat = 11,
    eParamYclid = 12,
    eParamWickedid = 13,
    eParamTwclid = 14,
    eParamHssc = 15,
    eParamHstc = 16,
    eParamHsfp = 17,
    eParamHsctatracking = 18,
    eParamWbraid = 19,
    eParamGbraid = 20,
    eParamYsclid = 21,
    e__Other__,
  };
  /**
   * Counts how often specific query parameters are stripped.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram QUERY_STRIPPING_COUNT_BY_PARAM.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, QueryStrippingCountByParamLabel> query_stripping_count_by_param(4570);

  /**
   * generated from contentblocking.query_stripping_param_count
   * If query params get stripped, how many per navigation/redirect.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram QUERY_STRIPPING_PARAM_COUNT.
   */
  constexpr impl::CustomDistributionMetric query_stripping_param_count(4571);

  /**
   * generated from contentblocking.storage_access_granted_count
   */
  enum class StorageAccessGrantedCountLabel: uint16_t {
    eStoragegranted = 0,
    eStorageaccessapi = 1,
    eOpenerafterui = 2,
    eOpener = 3,
    eRedirect = 4,
    eRedirecttracker = 5,
    eNavigation = 6,
    eStoragegrantedCt = 7,
    eStorageaccessapiCt = 8,
    eOpenerafteruiCt = 9,
    eOpenerCt = 10,
    eRedirectCt = 11,
    eRedirecttrackerCt = 12,
    eNavigationCt = 13,
    e__Other__,
  };
  /**
   * A count of the granted storage access. ('StorageGranted' = There was a storage access granted, 'StorageAccessAPI' = the storage access was granted by the storage access API, 'OpenerAfterUserInteraction' = the storage access was granted due to the heuristic 'OpenerAfterUserInteraction', 'Opener' = the storage access was granted due to the heuristic 'Opener', 'Redirect' = the storage access was granted due to the heuristic 'Redirect', 'RedirectTracker' = the storage access was granted due to the heuristic 'RedirectTracker'.) Note, StorageGranted is used as a baseline measurement, which should be the sum of all other measurements. We also duplicate all data reported into a corresponding *_CT label where the grant is given to a known classified tracker.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram STORAGE_ACCESS_GRANTED_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, StorageAccessGrantedCountLabel> storage_access_granted_count(4572);

  /**
   * generated from contentblocking.storage_access_remaining_days
   * The time remaining until expiration per storage access permissions, in days (one record per permission, not averaged).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram STORAGE_ACCESS_REMAINING_DAYS.
   */
  constexpr impl::CustomDistributionMetric storage_access_remaining_days(4573);

  /**
   * generated from contentblocking.strip_on_share_length_decrease
   * The decrease in the length of the URL when strip on share is used, only if at least one parameter is stripped
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram STRIP_ON_SHARE_LENGTH_DECREASE.
   */
  constexpr impl::CustomDistributionMetric strip_on_share_length_decrease(4574);

  /**
   * generated from contentblocking.strip_on_share_params_removed
   * The number of query parameters removed, if any, when strip on share is used
   * This metric was generated to correspond to the Legacy Telemetry linear histogram STRIP_ON_SHARE_PARAMS_REMOVED.
   */
  constexpr impl::CustomDistributionMetric strip_on_share_params_removed(4575);

  /**
   * generated from contentblocking.tp_allowlist_baseline_enabled
   * True if the tracking protection allowlist convenience option is enabled. Updates on "idle daily".
   */
  constexpr impl::BooleanMetric tp_allowlist_baseline_enabled(4576);

  /**
   * generated from contentblocking.tp_allowlist_convenience_enabled
   * True if the tracking protection allowlist baseline option is enabled. Updates on "idle daily".
   */
  constexpr impl::BooleanMetric tp_allowlist_convenience_enabled(4577);

  /**
   * generated from contentblocking.trackers_blocked_count
   * A count of the number of tracking events blocked. This metric was generated to correspond to the Legacy Telemetry scalar contentblocking.trackers_blocked_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> trackers_blocked_count(4578);

  /**
   * generated from contentblocking.tracking_protection_enabled
   */
  enum class TrackingProtectionEnabledLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True if tracking protection is enabled globally at startup.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TRACKING_PROTECTION_ENABLED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TrackingProtectionEnabledLabel> tracking_protection_enabled(4579);

  /**
   * generated from contentblocking.tracking_protection_pbm_disabled
   */
  enum class TrackingProtectionPbmDisabledLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True if tracking protection in Private Browsing mode is disabled at startup.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TRACKING_PROTECTION_PBM_DISABLED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TrackingProtectionPbmDisabledLabel> tracking_protection_pbm_disabled(4580);

  /**
   * generated from contentblocking.tracking_protection_shield
   * Status of the shield icon for each top-level pageload (outside of Private Browsing mode) when tracking protection is enabled (0 = there was a page load, this is used as a baseline, 1 = shield crossed out because CB was disabled on this page by the user, 2 = shield shown because some content was blocked)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRACKING_PROTECTION_SHIELD.
   */
  constexpr impl::CustomDistributionMetric tracking_protection_shield(4581);
}

namespace cookie_purging {
  /**
   * generated from cookie_purging.duration
   * Time spent per daily cookie purging activity, in milliseconds. This measures the time for all batch iterations of that day.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram COOKIE_PURGING_DURATION_MS.
   */
  constexpr impl::TimingDistributionMetric duration(4582);

  /**
   * generated from cookie_purging.interval_hours
   * How much time (in hours) passed between the current cookie purging activity and the one before that (cookie purging is run on 'daily idle')
   * This metric was generated to correspond to the Legacy Telemetry linear histogram COOKIE_PURGING_INTERVAL_HOURS.
   */
  constexpr impl::TimingDistributionMetric interval_hours(4583);

  /**
   * generated from cookie_purging.origins_purged
   * The number of origins that were purged during one run of cookie purging.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram COOKIE_PURGING_ORIGINS_PURGED.
   */
  constexpr impl::CustomDistributionMetric origins_purged(4584);

  /**
   * generated from cookie_purging.trackers_user_interaction_remaining_days
   * The time remaining until expiration per user interaction permissions of trackers at the time of purging, in days (one record per tracker, not averaged).
   * This metric was generated to correspond to the Legacy Telemetry linear histogram COOKIE_PURGING_TRACKERS_USER_INTERACTION_REMAINING_DAYS.
   */
  constexpr impl::TimingDistributionMetric trackers_user_interaction_remaining_days(4585);

  /**
   * generated from cookie_purging.trackers_with_user_interaction
   * The number of trackers that had user interaction at the time of purging.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram COOKIE_PURGING_TRACKERS_WITH_USER_INTERACTION.
   */
  constexpr impl::CustomDistributionMetric trackers_with_user_interaction(4586);
}

} // namespace mozilla::glean

#endif // mozilla_GleanAntitrackingMetrics_h
