/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PushSubscriptionChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "ExtendableEventBinding.h"
#include "PushSubscriptionChangeEvent.h"
#include "PushSubscriptionChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/PushSubscription.h"
#include "mozilla/dom/PushSubscriptionChangeEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(PushSubscriptionChangeEvent)

NS_IMPL_ADDREF_INHERITED(PushSubscriptionChangeEvent, ExtendableEvent)
NS_IMPL_RELEASE_INHERITED(PushSubscriptionChangeEvent, ExtendableEvent)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(PushSubscriptionChangeEvent, ExtendableEvent)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mNewSubscription)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mOldSubscription)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(PushSubscriptionChangeEvent, ExtendableEvent)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(PushSubscriptionChangeEvent, ExtendableEvent)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mNewSubscription)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mOldSubscription)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PushSubscriptionChangeEvent)
NS_INTERFACE_MAP_END_INHERITING(ExtendableEvent)

PushSubscriptionChangeEvent::PushSubscriptionChangeEvent(mozilla::dom::EventTarget* aOwner)
  : ExtendableEvent(aOwner)
{
}

PushSubscriptionChangeEvent::~PushSubscriptionChangeEvent()
{
}

PushSubscriptionChangeEvent*
PushSubscriptionChangeEvent::AsPushSubscriptionChangeEvent()
{
  return this;
}

JSObject*
PushSubscriptionChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PushSubscriptionChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PushSubscriptionChangeEvent>
PushSubscriptionChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PushSubscriptionChangeEventInit& aEventInitDict)
{
  RefPtr<PushSubscriptionChangeEvent> e = new PushSubscriptionChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mNewSubscription = aEventInitDict.mNewSubscription;
  e->mOldSubscription = aEventInitDict.mOldSubscription;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PushSubscriptionChangeEvent>
PushSubscriptionChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PushSubscriptionChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

PushSubscription*
PushSubscriptionChangeEvent::GetNewSubscription() const
{
  return mNewSubscription;
}

PushSubscription*
PushSubscriptionChangeEvent::GetOldSubscription() const
{
  return mOldSubscription;
}


} // namespace mozilla::dom
