/* THIS FILE IS AUTOGENERATED FROM OffscreenCanvas.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "ClientWebGLContext.h"
#include "EventHandlerBinding.h"
#include "EventTargetBinding.h"
#include "MainThreadUtils.h"
#include "OffscreenCanvasBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/ImageBitmap.h"
#include "mozilla/dom/ImageBitmapRenderingContext.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OffscreenCanvas.h"
#include "mozilla/dom/OffscreenCanvasRenderingContext2D.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "mozilla/webgpu/CanvasContext.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<OffscreenRenderingContextId>::Values[5];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, OffscreenRenderingContextId aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<OffscreenRenderingContextId>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<OffscreenRenderingContextId>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<OffscreenRenderingContextId>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsOffscreenCanvasRenderingContext2D()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsOffscreenCanvasRenderingContext2D(), "mOffscreenCanvasRenderingContext2D", aFlags);
  } else if (aUnion.IsImageBitmapRenderingContext()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsImageBitmapRenderingContext(), "mImageBitmapRenderingContext", aFlags);
  } else if (aUnion.IsWebGLRenderingContext()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsWebGLRenderingContext(), "mWebGLRenderingContext", aFlags);
  } else if (aUnion.IsWebGL2RenderingContext()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsWebGL2RenderingContext(), "mWebGL2RenderingContext", aFlags);
  } else if (aUnion.IsGPUCanvasContext()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsGPUCanvasContext(), "mGPUCanvasContext", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext& aUnion)
{
  aUnion.Uninit();
}



ImageEncodeOptions::ImageEncodeOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
ImageEncodeOptions::InitIds(JSContext* cx, ImageEncodeOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->quality_id.init(cx, "quality")) {
    return false;
  }
  return true;
}

bool
ImageEncodeOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  ImageEncodeOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<ImageEncodeOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->quality_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mQuality.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'quality' member of ImageEncodeOptions", &(mQuality.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mType)) {
      return false;
    }
  } else {
    mType.AssignLiteral(u"image/png");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
ImageEncodeOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
ImageEncodeOptions::TraceDictionary(JSTracer* trc)
{
}

ImageEncodeOptions&
ImageEncodeOptions::operator=(const ImageEncodeOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mQuality.Reset();
  if (aOther.mQuality.WasPassed()) {
    mQuality.Construct(aOther.mQuality.Value());
  }
  mType = aOther.mType;
  return *this;
}


bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToOffscreenCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::OffscreenCanvasRenderingContext2D>& memberSlot = RawSetAsOffscreenCanvasRenderingContext2D();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvasRenderingContext2D, mozilla::dom::OffscreenCanvasRenderingContext2D>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyOffscreenCanvasRenderingContext2D();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToOffscreenCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToOffscreenCanvasRenderingContext2D(cx, value, tryNext, passedToJSImpl);
}







bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToImageBitmapRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::ImageBitmapRenderingContext>& memberSlot = RawSetAsImageBitmapRenderingContext();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ImageBitmapRenderingContext, mozilla::dom::ImageBitmapRenderingContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyImageBitmapRenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToImageBitmapRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToImageBitmapRenderingContext(cx, value, tryNext, passedToJSImpl);
}







bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGLRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::ClientWebGLContext>& memberSlot = RawSetAsWebGLRenderingContext();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderingContext, mozilla::ClientWebGLContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyWebGLRenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGLRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWebGLRenderingContext(cx, value, tryNext, passedToJSImpl);
}







bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGL2RenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::ClientWebGLContext>& memberSlot = RawSetAsWebGL2RenderingContext();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGL2RenderingContext, mozilla::ClientWebGLContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyWebGL2RenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGL2RenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWebGL2RenderingContext(cx, value, tryNext, passedToJSImpl);
}







bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToGPUCanvasContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::webgpu::CanvasContext>& memberSlot = RawSetAsGPUCanvasContext();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::GPUCanvasContext, mozilla::webgpu::CanvasContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyGPUCanvasContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToGPUCanvasContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToGPUCanvasContext(cx, value, tryNext, passedToJSImpl);
}







bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToOffscreenCanvasRenderingContext2D(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToImageBitmapRenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToWebGLRenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToWebGL2RenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToGPUCanvasContext(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "OffscreenCanvasRenderingContext2D, ImageBitmapRenderingContext, WebGLRenderingContext, WebGL2RenderingContext, GPUCanvasContext");
    return false;
  }
  return true;
}

bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
OffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eOffscreenCanvasRenderingContext2D: {
      if (!GetOrCreateDOMReflector(cx, mValue.mOffscreenCanvasRenderingContext2D.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eImageBitmapRenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mImageBitmapRenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eWebGLRenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mWebGLRenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eWebGL2RenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mWebGL2RenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eGPUCanvasContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mGPUCanvasContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext(OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eOffscreenCanvasRenderingContext2D: {
      mType = eOffscreenCanvasRenderingContext2D;
      mValue.mOffscreenCanvasRenderingContext2D.SetValue(std::move(aOther.mValue.mOffscreenCanvasRenderingContext2D.Value()));
      break;
    }
    case eImageBitmapRenderingContext: {
      mType = eImageBitmapRenderingContext;
      mValue.mImageBitmapRenderingContext.SetValue(std::move(aOther.mValue.mImageBitmapRenderingContext.Value()));
      break;
    }
    case eWebGLRenderingContext: {
      mType = eWebGLRenderingContext;
      mValue.mWebGLRenderingContext.SetValue(std::move(aOther.mValue.mWebGLRenderingContext.Value()));
      break;
    }
    case eWebGL2RenderingContext: {
      mType = eWebGL2RenderingContext;
      mValue.mWebGL2RenderingContext.SetValue(std::move(aOther.mValue.mWebGL2RenderingContext.Value()));
      break;
    }
    case eGPUCanvasContext: {
      mType = eGPUCanvasContext;
      mValue.mGPUCanvasContext.SetValue(std::move(aOther.mValue.mGPUCanvasContext.Value()));
      break;
    }
  }
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToOffscreenCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::OffscreenCanvasRenderingContext2D>& memberSlot = RawSetAsOffscreenCanvasRenderingContext2D();
    static_assert(IsRefcounted<mozilla::dom::OffscreenCanvasRenderingContext2D>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvasRenderingContext2D, mozilla::dom::OffscreenCanvasRenderingContext2D>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyOffscreenCanvasRenderingContext2D();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToOffscreenCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToOffscreenCanvasRenderingContext2D(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvasRenderingContext2D>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::RawSetAsOffscreenCanvasRenderingContext2D()
{
  if (mType == eOffscreenCanvasRenderingContext2D) {
    return mValue.mOffscreenCanvasRenderingContext2D.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eOffscreenCanvasRenderingContext2D;
  return mValue.mOffscreenCanvasRenderingContext2D.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvasRenderingContext2D>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::SetAsOffscreenCanvasRenderingContext2D()
{
  if (mType == eOffscreenCanvasRenderingContext2D) {
    return mValue.mOffscreenCanvasRenderingContext2D.Value();
  }
  Uninit();
  mType = eOffscreenCanvasRenderingContext2D;
  return mValue.mOffscreenCanvasRenderingContext2D.SetValue();
}


void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::DestroyOffscreenCanvasRenderingContext2D()
{
  MOZ_RELEASE_ASSERT(IsOffscreenCanvasRenderingContext2D(), "Wrong type!");
  mValue.mOffscreenCanvasRenderingContext2D.Destroy();
  mType = eUninitialized;
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToImageBitmapRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::ImageBitmapRenderingContext>& memberSlot = RawSetAsImageBitmapRenderingContext();
    static_assert(IsRefcounted<mozilla::dom::ImageBitmapRenderingContext>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ImageBitmapRenderingContext, mozilla::dom::ImageBitmapRenderingContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyImageBitmapRenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToImageBitmapRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToImageBitmapRenderingContext(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmapRenderingContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::RawSetAsImageBitmapRenderingContext()
{
  if (mType == eImageBitmapRenderingContext) {
    return mValue.mImageBitmapRenderingContext.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eImageBitmapRenderingContext;
  return mValue.mImageBitmapRenderingContext.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmapRenderingContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::SetAsImageBitmapRenderingContext()
{
  if (mType == eImageBitmapRenderingContext) {
    return mValue.mImageBitmapRenderingContext.Value();
  }
  Uninit();
  mType = eImageBitmapRenderingContext;
  return mValue.mImageBitmapRenderingContext.SetValue();
}


void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::DestroyImageBitmapRenderingContext()
{
  MOZ_RELEASE_ASSERT(IsImageBitmapRenderingContext(), "Wrong type!");
  mValue.mImageBitmapRenderingContext.Destroy();
  mType = eUninitialized;
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGLRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::ClientWebGLContext>& memberSlot = RawSetAsWebGLRenderingContext();
    static_assert(IsRefcounted<mozilla::ClientWebGLContext>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderingContext, mozilla::ClientWebGLContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyWebGLRenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGLRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWebGLRenderingContext(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::RawSetAsWebGLRenderingContext()
{
  if (mType == eWebGLRenderingContext) {
    return mValue.mWebGLRenderingContext.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eWebGLRenderingContext;
  return mValue.mWebGLRenderingContext.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::SetAsWebGLRenderingContext()
{
  if (mType == eWebGLRenderingContext) {
    return mValue.mWebGLRenderingContext.Value();
  }
  Uninit();
  mType = eWebGLRenderingContext;
  return mValue.mWebGLRenderingContext.SetValue();
}


void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::DestroyWebGLRenderingContext()
{
  MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
  mValue.mWebGLRenderingContext.Destroy();
  mType = eUninitialized;
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGL2RenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::ClientWebGLContext>& memberSlot = RawSetAsWebGL2RenderingContext();
    static_assert(IsRefcounted<mozilla::ClientWebGLContext>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGL2RenderingContext, mozilla::ClientWebGLContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyWebGL2RenderingContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToWebGL2RenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWebGL2RenderingContext(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::RawSetAsWebGL2RenderingContext()
{
  if (mType == eWebGL2RenderingContext) {
    return mValue.mWebGL2RenderingContext.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eWebGL2RenderingContext;
  return mValue.mWebGL2RenderingContext.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::SetAsWebGL2RenderingContext()
{
  if (mType == eWebGL2RenderingContext) {
    return mValue.mWebGL2RenderingContext.Value();
  }
  Uninit();
  mType = eWebGL2RenderingContext;
  return mValue.mWebGL2RenderingContext.SetValue();
}


void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::DestroyWebGL2RenderingContext()
{
  MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
  mValue.mWebGL2RenderingContext.Destroy();
  mType = eUninitialized;
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToGPUCanvasContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::webgpu::CanvasContext>& memberSlot = RawSetAsGPUCanvasContext();
    static_assert(IsRefcounted<mozilla::webgpu::CanvasContext>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::GPUCanvasContext, mozilla::webgpu::CanvasContext>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyGPUCanvasContext();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::TrySetToGPUCanvasContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToGPUCanvasContext(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::webgpu::CanvasContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::RawSetAsGPUCanvasContext()
{
  if (mType == eGPUCanvasContext) {
    return mValue.mGPUCanvasContext.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eGPUCanvasContext;
  return mValue.mGPUCanvasContext.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::webgpu::CanvasContext>&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::SetAsGPUCanvasContext()
{
  if (mType == eGPUCanvasContext) {
    return mValue.mGPUCanvasContext.Value();
  }
  Uninit();
  mType = eGPUCanvasContext;
  return mValue.mGPUCanvasContext.SetValue();
}


void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::DestroyGPUCanvasContext()
{
  MOZ_RELEASE_ASSERT(IsGPUCanvasContext(), "Wrong type!");
  mValue.mGPUCanvasContext.Destroy();
  mType = eUninitialized;
}



bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToOffscreenCanvasRenderingContext2D(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToImageBitmapRenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToWebGLRenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToWebGL2RenderingContext(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToGPUCanvasContext(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "OffscreenCanvasRenderingContext2D, ImageBitmapRenderingContext, WebGLRenderingContext, WebGL2RenderingContext, GPUCanvasContext");
    return false;
  }
  return true;
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eOffscreenCanvasRenderingContext2D: {
      DestroyOffscreenCanvasRenderingContext2D();
      break;
    }
    case eImageBitmapRenderingContext: {
      DestroyImageBitmapRenderingContext();
      break;
    }
    case eWebGLRenderingContext: {
      DestroyWebGLRenderingContext();
      break;
    }
    case eWebGL2RenderingContext: {
      DestroyWebGL2RenderingContext();
      break;
    }
    case eGPUCanvasContext: {
      DestroyGPUCanvasContext();
      break;
    }
  }
}

bool
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eOffscreenCanvasRenderingContext2D: {
      if (!GetOrCreateDOMReflector(cx, mValue.mOffscreenCanvasRenderingContext2D.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eImageBitmapRenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mImageBitmapRenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eWebGLRenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mWebGLRenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eWebGL2RenderingContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mWebGL2RenderingContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eGPUCanvasContext: {
      if (!GetOrCreateDOMReflector(cx, mValue.mGPUCanvasContext.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::operator=(OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext&& aOther)
{
  this->~OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext();
  new (this) OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext (std::move(aOther));
  return *this;
}


OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext&
OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext::operator=(const OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eOffscreenCanvasRenderingContext2D: {
      SetAsOffscreenCanvasRenderingContext2D() = aOther.GetAsOffscreenCanvasRenderingContext2D();
      break;
    }
    case eImageBitmapRenderingContext: {
      SetAsImageBitmapRenderingContext() = aOther.GetAsImageBitmapRenderingContext();
      break;
    }
    case eWebGLRenderingContext: {
      SetAsWebGLRenderingContext() = aOther.GetAsWebGLRenderingContext();
      break;
    }
    case eWebGL2RenderingContext: {
      SetAsWebGL2RenderingContext() = aOther.GetAsWebGL2RenderingContext();
      break;
    }
    case eGPUCanvasContext: {
      SetAsGPUCanvasContext() = aOther.GetAsGPUCanvasContext();
      break;
    }
  }
  return *this;
}


namespace OffscreenCanvas_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_width(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "width", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Width());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_width(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvas.width setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "width", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetWidth(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetWidth(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.width setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo width_getterinfo = {
  { get_width },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo width_setterinfo = {
  { (JSJitGetterOp)set_width },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_height(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "height", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Height());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_height(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvas.height setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "height", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetHeight(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetHeight(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.height setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo height_getterinfo = {
  { get_height },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo height_setterinfo = {
  { (JSJitGetterOp)set_height },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getContext(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvas.getContext");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "getContext", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvas.getContext", 1)) {
    return false;
  }
  OffscreenRenderingContextId arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                       binding_detail::EnumStrings<OffscreenRenderingContextId>::Values,
                                                                       "OffscreenRenderingContextId", "argument 1",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg0 = static_cast<OffscreenRenderingContextId>(index);
  }
  JS::Rooted<JS::Value> arg1(cx);
  if (args.hasDefined(1)) {
    arg1 = args[1];
  } else {
    arg1 = JS::NullValue();
  }
  FastErrorResult rv;
  Nullable<OwningOffscreenCanvasRenderingContext2DOrImageBitmapRenderingContextOrWebGLRenderingContextOrWebGL2RenderingContextOrGPUCanvasContext> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetContext(cx, arg0, arg1, result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetContext(cx, arg0, arg1, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.getContext"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getContext_methodinfo = {
  { (JSJitGetterOp)getContext },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
transferToImageBitmap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "transferToImageBitmap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::ImageBitmap>(MOZ_KnownLive(self)->TransferToImageBitmap(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.transferToImageBitmap"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo transferToImageBitmap_methodinfo = {
  { (JSJitGetterOp)transferToImageBitmap },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
convertToBlob(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvas.convertToBlob");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "convertToBlob", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  binding_detail::FastImageEncodeOptions arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->ConvertToBlob(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.convertToBlob"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
convertToBlob_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = convertToBlob(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo convertToBlob_methodinfo = {
  { (JSJitGetterOp)convertToBlob_promiseWrapper },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontextlost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "oncontextlost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontextlost());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontextlost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "oncontextlost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontextlost(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontextlost(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontextlost_getterinfo = {
  { get_oncontextlost },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontextlost_setterinfo = {
  { (JSJitGetterOp)set_oncontextlost },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontextrestored(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "oncontextrestored", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontextrestored());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontextrestored(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "oncontextrestored", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontextrestored(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontextrestored(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontextrestored_getterinfo = {
  { get_oncontextrestored },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontextrestored_setterinfo = {
  { (JSJitGetterOp)set_oncontextrestored },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
toBlob(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "toBlob", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvas*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eOffscreenCanvasToBlob);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  JS::Rooted<JS::Value> arg1(cx);
  if (args.hasDefined(1)) {
    arg1 = args[1];
  } else {
    arg1 = JS::UndefinedValue();
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->ToBlob(cx, NonNullHelper(Constify(arg0)), arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas.toBlob"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
toBlob_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = toBlob(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo toBlob_methodinfo = {
  { (JSJitGetterOp)toBlob_promiseWrapper },
  { prototypes::id::OffscreenCanvas },
  { PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::OffscreenCanvas* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::OffscreenCanvas>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::OffscreenCanvas>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getContext", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getContext_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("transferToImageBitmap", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&transferToImageBitmap_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("convertToBlob", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&convertToBlob_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("toBlob", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&toBlob_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("width", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &width_getterinfo, GenericSetter<NormalThisPolicy>, &width_setterinfo),
  JSPropertySpec::nativeAccessors("height", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &height_getterinfo, GenericSetter<NormalThisPolicy>, &height_setterinfo),
  JSPropertySpec::nativeAccessors("oncontextlost", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &oncontextlost_getterinfo, GenericSetter<NormalThisPolicy>, &oncontextlost_setterinfo),
  JSPropertySpec::nativeAccessors("oncontextrestored", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &oncontextrestored_getterinfo, GenericSetter<NormalThisPolicy>, &oncontextrestored_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[8];
static PropertyInfo sNativeProperties_propertyInfos[8];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  8,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[4] }
  }
};
static_assert(8 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::OffscreenCanvas,
  constructors::id::OffscreenCanvas,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "OffscreenCanvas constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvas", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "OffscreenCanvas");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::OffscreenCanvas,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "OffscreenCanvas constructor", 2)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::OffscreenCanvas>(mozilla::dom::OffscreenCanvas::Constructor(global, arg0, arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvas constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth,
  prototypes::id::OffscreenCanvas,
  true,
  2,
  "OffscreenCanvas",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "OffscreenCanvasPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::OffscreenCanvas,
  PrototypeTraits<prototypes::id::OffscreenCanvas>::Depth,
  &sNativePropertyHooks,
  EventTarget_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "OffscreenCanvas",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::OffscreenCanvas>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::OffscreenCanvas, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::OffscreenCanvas>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::OffscreenCanvas>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::OffscreenCanvas>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::OffscreenCanvas>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::OffscreenCanvas* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::OffscreenCanvas>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::OffscreenCanvas*>);
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::OffscreenCanvas> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::OffscreenCanvas);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::OffscreenCanvas);

  JS::Handle<JSObject*> parentProto(EventTarget_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 2, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "OffscreenCanvas",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::OffscreenCanvas,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::OffscreenCanvas,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace OffscreenCanvas_Binding



} // namespace dom


} // namespace mozilla
