/***************************************************************************
* Copyright (c) 2014 Pier Luigi Fiorini <pierluigi.fiorini@gmail.com>
* Copyright (c) 2013 Abdurrahman AVCI <abdurrahmanavci@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the
* Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
***************************************************************************/

#ifndef DDM_XORGDISPLAYSERVER_H
#define DDM_XORGDISPLAYSERVER_H

#include "XAuth.h"

class QProcess;

namespace DDM {
    class Display;

    class XorgDisplayServer : public QObject {
        Q_OBJECT
        Q_DISABLE_COPY(XorgDisplayServer)
    public:
        explicit XorgDisplayServer(Display *parent);
        ~XorgDisplayServer();

        const QByteArray cookie() const;

        QString display{};

    Q_SIGNALS:
        void stopped();

    public slots:
        bool start(int vt);
        void stop();
        void finished();
        void setupDisplay();

    private:
        bool m_started { false };

        XAuth m_xauth;

        QProcess *process { nullptr };

        void changeOwner(const QString &fileName);
    };
}

#endif // DDM_XORGDISPLAYSERVER_H
