/* do not edit automatically generated by mc from M2Search.  */
/* M2Search.mod provides a mechanism to search selected directories.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Search_C

#include "GM2Search.h"
#   include "GM2FileName.h"
#   include "GAssertion.h"
#   include "GPathName.h"
#   include "GDynamicStrings.h"

#   define GarbageDebugging false
#   define DefaultDefExt ".def"
#   define DefaultModExt ".mod"
static DynamicStrings_String Def;
static DynamicStrings_String Mod;

/*
   FindSourceFile - attempts to locate the source file FileName.
                    If a file is found then TRUE is returned otherwise
                    FALSE is returned.
                    The parameter FullPath is set indicating the
                    absolute location of source FileName.
                    FullPath will be totally overwritten and should
                    not be initialized by InitString before this function
                    is called.
                    FullPath is set to NIL if this function returns FALSE.
                    FindSourceFile sets FullPath to a new string if successful.
                    The string FileName is not altered.
*/

extern "C" bool M2Search_FindSourceFile (DynamicStrings_String FileName, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   FindSourceDefFile - attempts to find the definition module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

extern "C" bool M2Search_FindSourceDefFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   FindSourceModFile - attempts to find the implementation module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

extern "C" bool M2Search_FindSourceModFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   SetDefExtension - sets the default extension for definition modules to, ext.
                     The string, ext, should be deallocated by the caller at
                     an appropriate time.
*/

extern "C" void M2Search_SetDefExtension (DynamicStrings_String ext);

/*
   SetModExtension - sets the default extension for implementation and program
                     modules to, ext. The string, ext, should be deallocated
                     by the caller at an appropriate time.
*/

extern "C" void M2Search_SetModExtension (DynamicStrings_String ext);

/*
   Init - initializes the def and mod default string names to NIL.
*/

static void Init (void);


/*
   Init - initializes the def and mod default string names to NIL.
*/

static void Init (void)
{
  Def = static_cast<DynamicStrings_String> (NULL);
  Mod = static_cast<DynamicStrings_String> (NULL);
}


/*
   FindSourceFile - attempts to locate the source file FileName.
                    If a file is found then TRUE is returned otherwise
                    FALSE is returned.
                    The parameter FullPath is set indicating the
                    absolute location of source FileName.
                    FullPath will be totally overwritten and should
                    not be initialized by InitString before this function
                    is called.
                    FullPath is set to NIL if this function returns FALSE.
                    FindSourceFile sets FullPath to a new string if successful.
                    The string FileName is not altered.
*/

extern "C" bool M2Search_FindSourceFile (DynamicStrings_String FileName, DynamicStrings_String *FullPath, DynamicStrings_String *named)
{
  (*FullPath) = PathName_FindNamedPathFile (FileName, named);
  return (*FullPath) != NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindSourceDefFile - attempts to find the definition module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

extern "C" bool M2Search_FindSourceDefFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named)
{
  DynamicStrings_String f;

  if (Def != NULL)
    {
      f = M2FileName_CalculateFileName (Stem, Def);
      if (M2Search_FindSourceFile (f, FullPath, named))
        {
          return true;
        }
      f = DynamicStrings_KillString (f);
    }
  /* Try the GNU Modula-2 default extension.  */
  f = M2FileName_CalculateFileName (Stem, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".def", 4)));
  return M2Search_FindSourceFile (f, FullPath, named);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindSourceModFile - attempts to find the implementation module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

extern "C" bool M2Search_FindSourceModFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named)
{
  DynamicStrings_String f;

  if (Mod != NULL)
    {
      f = M2FileName_CalculateFileName (Stem, Mod);
      if (M2Search_FindSourceFile (f, FullPath, named))
        {
          return true;
        }
      f = DynamicStrings_KillString (f);
    }
  /* Try the GNU Modula-2 default extension.  */
  f = M2FileName_CalculateFileName (Stem, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".mod", 4)));
  return M2Search_FindSourceFile (f, FullPath, named);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetDefExtension - sets the default extension for definition modules to, ext.
                     The string, ext, should be deallocated by the caller at
                     an appropriate time.
*/

extern "C" void M2Search_SetDefExtension (DynamicStrings_String ext)
{
  Def = DynamicStrings_KillString (Def);
  Def = DynamicStrings_Dup (ext);
}


/*
   SetModExtension - sets the default extension for implementation and program
                     modules to, ext. The string, ext, should be deallocated
                     by the caller at an appropriate time.
*/

extern "C" void M2Search_SetModExtension (DynamicStrings_String ext)
{
  Mod = DynamicStrings_KillString (Mod);
  Mod = DynamicStrings_Dup (ext);
}

extern "C" void _M2_M2Search_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Search_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
