/* do not edit automatically generated by mc from M2GCCDeclare.  */
/* M2GCCDeclare.def declares Modula-2 types to GCC.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2GCCDeclare_H)
#   define _M2GCCDeclare_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "Ggcctypes.h"
#   include "GM2BasicBlock.h"

#   if defined (_M2GCCDeclare_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef struct M2GCCDeclare_WalkAction_p M2GCCDeclare_WalkAction;

typedef struct M2GCCDeclare_IsAction_p M2GCCDeclare_IsAction;

typedef void (*M2GCCDeclare_WalkAction_t) (unsigned int);
struct M2GCCDeclare_WalkAction_p { M2GCCDeclare_WalkAction_t proc; };

typedef bool (*M2GCCDeclare_IsAction_t) (unsigned int);
struct M2GCCDeclare_IsAction_p { M2GCCDeclare_IsAction_t proc; };


/*
   FoldConstants - a wrapper for ResolveConstantExpressions.
*/

EXTERN void M2GCCDeclare_FoldConstants (M2BasicBlock_BasicBlock bb);

/*
   StartDeclareScope - declares types, variables associated with this scope.
*/

EXTERN void M2GCCDeclare_StartDeclareScope (unsigned int scope);

/*
   EndDeclareScope -
*/

EXTERN void M2GCCDeclare_EndDeclareScope (void);

/*
   DeclareParameters -
*/

EXTERN void M2GCCDeclare_DeclareParameters (unsigned int sym);

/*
   DeclareConstant - if, sym, is a constant then declare it.
                     The constant must be solvable at this point.
*/

EXTERN void M2GCCDeclare_DeclareConstant (unsigned int tokenno, unsigned int sym);

/*
   DeclareConstructor - if, sym, is a constructor then declare it.
                        The constructor must be solvable at this point.
*/

EXTERN void M2GCCDeclare_DeclareConstructor (unsigned int tokenno, unsigned int quad, unsigned int sym);

/*
   TryDeclareConstant - try and declare a constant.  If, sym, is a
                        constant try and declare it, if we cannot
                        then enter it into the to do list.
*/

EXTERN void M2GCCDeclare_TryDeclareConstant (unsigned int tokenno, unsigned int sym);

/*
   TryDeclareType - try and declare a type.  If sym is a
                    type try and declare it, if we cannot
                    then enter it into the to do list.
*/

EXTERN void M2GCCDeclare_TryDeclareType (unsigned int type);

/*
   TryDeclareConstructor - try and declare a constructor.  If, sym, is a
                           constructor try and declare it, if we cannot
                           then enter it into the to do list.
*/

EXTERN void M2GCCDeclare_TryDeclareConstructor (unsigned int tokenno, unsigned int sym);

/*
   DeclareLocalVariables - lists the Local variables for procedure
                           together with their offset.
*/

EXTERN void M2GCCDeclare_DeclareLocalVariables (unsigned int procedure);

/*
   DeclareLocalVariable - declare a local variable var.
*/

EXTERN void M2GCCDeclare_DeclareLocalVariable (unsigned int var);

/*
   DeclareProcedure - declares procedure, sym, or all procedures inside
                      module sym.
*/

EXTERN void M2GCCDeclare_DeclareProcedure (unsigned int sym);

/*
   DeclareModuleVariables - declares Module variables for a module
                            which inside a procedure.
*/

EXTERN void M2GCCDeclare_DeclareModuleVariables (unsigned int sym);

/*
   IsProcedureGccNested - returns TRUE if procedure, sym, will be considered
                          as nested by GCC.
                          This will occur if either its outer defining scope
                          is a procedure or is a module which is inside a
                          procedure.
*/

EXTERN bool M2GCCDeclare_IsProcedureGccNested (unsigned int sym);

/*
   PoisonSymbols - poisons all gcc symbols from procedure, sym.
                   A debugging aid.
*/

EXTERN void M2GCCDeclare_PoisonSymbols (unsigned int sym);

/*
   PromoteToString - declare, sym, and then promote it to a string.
                     Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

EXTERN tree M2GCCDeclare_PromoteToString (unsigned int tokenno, unsigned int sym);

/*
   PromoteToCString - declare, sym, and then promote it to a string.
                      Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

EXTERN tree M2GCCDeclare_PromoteToCString (unsigned int tokenno, unsigned int sym);

/*
   CompletelyResolved - returns TRUE if a symbol has been completely resolved
                        and is not partially declared (such as a record,
                        array or procedure type).
*/

EXTERN bool M2GCCDeclare_CompletelyResolved (unsigned int sym);

/*
   ConstantKnownAndUsed -
*/

EXTERN void M2GCCDeclare_ConstantKnownAndUsed (unsigned int sym, tree t);

/*
   PutToBeSolvedByQuads - places, sym, in this list.
*/

EXTERN void M2GCCDeclare_PutToBeSolvedByQuads (unsigned int sym);

/*
   MarkExported - tell GCC to mark all exported procedures in module sym.
*/

EXTERN void M2GCCDeclare_MarkExported (unsigned int sym);

/*
   GetTypeMin - returns a symbol corresponding to MIN(type)
*/

EXTERN unsigned int M2GCCDeclare_GetTypeMin (unsigned int type);

/*
   GetTypeMax - returns a symbol corresponding to MAX(type)
*/

EXTERN unsigned int M2GCCDeclare_GetTypeMax (unsigned int type);

/*
   PrintSym - prints limited information about a symbol.
*/

EXTERN void M2GCCDeclare_PrintSym (unsigned int sym);

/*
   IncludeDumpSymbol - include sym into the watch list and all syms dependants.
*/

EXTERN void M2GCCDeclare_IncludeDumpSymbol (unsigned int sym);

/*
   DumpFilteredResolver - dumps the gimple or tree representation of all watched symbols.
*/

EXTERN void M2GCCDeclare_DumpFilteredResolver (void);

/*
   DumpFilteredDefinitive - dumps the gimple or tree representation of all watched symbols.
*/

EXTERN void M2GCCDeclare_DumpFilteredDefinitive (void);

/*
   InitDeclarations - initializes default types and the source filename.
*/

EXTERN void M2GCCDeclare_InitDeclarations (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
